####PCA&Morphospace####

#Install Packages#

library(FactoMineR)
library(xlsx)

#Load Following Functions#

Results.PCA <- function(res.pca) {
  eigenvalues <- res.pca$eig
  print(eigenvalues[, 1:2])
  barplot(eigenvalues[, 2], xlab= "Principal Components", ylab = "%Variance")
}

Plot_ConvexHull<-function(xcoord, ycoord, bgcolor){
  hpts <- chull(x = xcoord, y = ycoord)
  hpts <- c(hpts, hpts[1])
  #lines(xcoord[hpts], ycoord[hpts], col = lcolor)
  polygon(x = xcoord[hpts], y =  ycoord[hpts], col = adjustcolor(bgcolor, alpha.f = 0.7) , border = NA)
}

Plot_PCA_Figure <- function(PC.scores, xlab, yLab, DuckData) {
  plot(PC.scores[,"Dim.1"], PC.scores[,"Dim.2"], xlab= xlab, ylab= yLab, pch = 19, col="transparent", cex=1, cex.axis=0.8, cex.lab=1.2)
  abline(v=c(0), lwd=10000, col="gray98", lty=1)
  abline(h=c(0), lwd=1.5, col="gray85",lty=2)
  abline(v=c(0), lwd=1.5, col="gray85", lty=2)
  box(lwd=1.5)
  IR_list <- row.names(PC.scores)[DuckData[,1] == 'IR']
  MA_list <- row.names(PC.scores)[DuckData[,1] == 'MA']
  AY_list <- row.names(PC.scores)[DuckData[,1] == 'AY']
  Plot_ConvexHull(xcoord=PC.scores[IR_list,][,1],
                  ycoord=PC.scores[IR_list,][,2], bgcolor="skyblue4")
  Plot_ConvexHull(xcoord=PC.scores[MA_list,][,1],
                  ycoord=PC.scores[MA_list,][,2], bgcolor="lightyellow2")
  Plot_ConvexHull(xcoord=PC.scores[AY_list,][,1],
                  ycoord=PC.scores[AY_list,][,2], bgcolor="sienna3")
  points(PC.scores[IR_list,][,1], PC.scores[IR_list,][,2], pch=23,
         col="black", bg="skyblue4", cex=1.2)
  points(PC.scores[MA_list,][,1], PC.scores[MA_list,][,2], pch=22,
         col="black", bg="lightyellow2", cex=1.2)
  points(PC.scores[AY_list,][,1], PC.scores[AY_list,][,2], pch=21,
         col="black", bg="sienna3", cex=1.2)
}

#Load Data#

Data.norm <- read.xlsx("Duck_Parameter_Data.xlsx", sheetIndex = 1, header = TRUE, row.names = 1)
colnames(Data.norm)[2:36] <- c("HUL", "FAL", "CML", "MAL", "FLL",
                               "THL", "SHL", "TML", "PEL", "HLL",
                               "NEL", "SHW", "STL", "GAL", "HPW",
                               "HEMH", "NMH", "TOMH", "HUMH", "FMH",
                               "MAMH", "THMH", "SMH", "MTMH", "PMH",
                               "HDSV", "NSV", "TOSV", "HUSV", "FSV",
                               "MASV", "THSV", "SSV", "MTSV", "PSV")

#Organise mean, standardised values for each dataset#

HindData <- Data.norm[,7:11] #hindlimb relative values
ForeData <- Data.norm[,2:6] #forelimb relative values
OtherData <- Data.norm[,12:16] #other relative values (e.g. sternum)
AllData <- Data.norm[,2:16] #combined relative values
ConvexHull <- Data.norm[,17:26]
SkinSegs <- Data.norm[,27:36]

#Run PCA analyses#

Hind.pca <- PCA(HindData, scale.unit = TRUE)
Fore.pca <- PCA(ForeData, scale.unit = TRUE)
Other.pca <- PCA(OtherData, scale.unit = TRUE)
All.pca <- PCA(AllData, scale.unit = TRUE)
Hull.pca <- PCA(ConvexHull, scale.unit = TRUE)
Skin.pca <-PCA(SkinSegs, scale.unit = TRUE)

#PCA outputs#

Results.PCA(Hind.pca)
Results.PCA(Fore.pca)
Results.PCA(Other.pca)
Results.PCA(All.pca)
Results.PCA(Hull.pca)
Results.PCA(Skin.pca)

#Extract individual co-ordinates#

Hind.coords <- as.matrix(Hind.pca$ind$coord)
Fore.coords <- as.matrix(Fore.pca$ind$coord)
Other.coords <- as.matrix(Other.pca$ind$coord)
All.coords <- as.matrix(All.pca$ind$coord)
Hull.coords <- as.matrix(Hull.pca$ind$coord)
Skin.coords <- as.matrix(Skin.pca$ind$coord)

#Plot Figure 1A Combined Linear Parameters PCA

tiff(filename = "Figure 1A.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (68.54%)"
yLab <- "PC2 (15.79%)"
Plot_PCA_Figure(All.coords, xLab, yLab, Data.norm)
text(-5.6, 1.7, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Figure 1A_Biplot.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(All.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white', xlim = c(-2,2), ylim = c(-1.5,1.5))

All.X.Cor <- All.pca[["var"]][["cor"]][,1]
lapply(All.X.Cor, "*", 2)
All.Y.Cor <- All.pca[["var"]][["cor"]][,2]
lapply(All.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = All.X.Cor, 
       y0 = 0, y1 = All.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = All.X.Cor, y = All.Y.Cor, 
     labels = row.names(All.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(4, 4, 1, 1, 4, 4, 4, 4, 4, 4, 1, 3, 4, 4, 3)) #FEL,TIL,MTL,D3L,HLL,HUL,FAL,MCL,MAL,FLL,HPW,SHW,GAL,STL

dev.off()


#Plot Figure 1B Skin Segment Volumes PCA

tiff(filename = "Figure 1B.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (55.58%)"
yLab <- "PC2 (20.77%)"
Plot_PCA_Figure(Skin.coords, xLab, yLab, Data.norm)
text(-3.45, 2.7, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Figure 1B_Biplot.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(Skin.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white', xlim = c(-3.4,3.4), ylim = c(-1.3,1.3))

Skin.X.Cor <- Skin.pca[["var"]][["cor"]][,1]
lapply(Skin.X.Cor, "*", 2)
Skin.Y.Cor <- Skin.pca[["var"]][["cor"]][,2]
lapply(Skin.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = Skin.X.Cor, 
       y0 = 0, y1 = Skin.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = Skin.X.Cor, y = Skin.Y.Cor, 
     labels = row.names(Skin.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(3, 1, 2, 3, 3, 3, 4, 3, 4, 3)) #HDSV,NSV,TOSV,HUSV,FSV,MASV,THSV,SSV,MTSV,PSV

dev.off()


#Plot Figure S3:1 Hindlimb Segment Lengths

tiff(filename = "Figure S3_1.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (90.12%)"
yLab <- "PC2 (7.30%)"
Plot_PCA_Figure(Hind.coords, xLab, yLab, Data.norm)
text(-2.8, 1.1, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Biplot S3_1.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(Hind.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white')

Hind.X.Cor <- Hind.pca[["var"]][["cor"]][,1]
lapply(Hind.X.Cor, "*", 2)
Hind.Y.Cor <- Hind.pca[["var"]][["cor"]][,2]
lapply(Hind.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = Hind.X.Cor, 
       y0 = 0, y1 = Hind.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = Hind.X.Cor, y = Hind.Y.Cor, 
     labels = row.names(Hind.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(4, 4, 4, 3, 4)) #FEL, TIL, MTL, D3L, HLL

dev.off()


#Plot Figure S3:2 Forelimb Segment Lengths

tiff(filename = "Figure S3_2.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (87.06%)"
yLab <- "PC2 (8.83%)"
Plot_PCA_Figure(Fore.coords, xLab, yLab, Data.norm)
text(-4.4, 0.9, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Biplot S3_2.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(Fore.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white')

Fore.X.Cor <- Fore.pca[["var"]][["cor"]][,1]
lapply(Fore.X.Cor, "*", 2)
Fore.Y.Cor <- Fore.pca[["var"]][["cor"]][,2]
lapply(Fore.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = Fore.X.Cor, 
       y0 = 0, y1 = Fore.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = Fore.X.Cor, y = Fore.Y.Cor, 
     labels = row.names(Fore.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(1, 4, 3, 3, 4)) #HUL, FAL, MCL, MAL, FLL

dev.off()


#Plot Figure S3:3 Non-appendicular segment lengths

tiff(filename = "Figure S3_3.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (58.58%)"
yLab <- "PC2 (22.35%)"
Plot_PCA_Figure(Other.coords, xLab, yLab, Data.norm)
text(-2.8, 1.75, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Biplot S3_3_Blank.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(Other.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white')

Other.X.Cor <- Other.pca[["var"]][["cor"]][,1]
lapply(Other.X.Cor, "*", 2)
Other.Y.Cor <- Other.pca[["var"]][["cor"]][,2]
lapply(Other.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = Other.X.Cor, 
       y0 = 0, y1 = Other.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = Other.X.Cor, y = Other.Y.Cor, 
     labels = row.names(Other.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(4, 3, 1, 3, 4)) #HPW, SHW, GAL, STL

dev.off()


#Plot Figure S3:4 Minimum Convex Hull Volumes

tiff(filename = "Figure S3_4.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot.new()

xLab <- "PC1 (38.62%)"
yLab <- "PC2 (18.08%)"
Plot_PCA_Figure(Hull.coords, xLab, yLab, Data.norm)
text(-3.45, 2.7, labels = "", cex = 2, font = 2)

dev.off()

tiff(filename = "Biplot S3_4_Blank.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

plot(Hull.coords[,1:2], bty = 'n', yaxt="n", xaxt="n", xlab = '', ylab = '', col = 'white')

Hull.X.Cor <- Hull.pca[["var"]][["cor"]][,1]
lapply(Hull.X.Cor, "*", 2)
Hull.Y.Cor <- Hull.pca[["var"]][["cor"]][,2]
lapply(Hull.Y.Cor, "*", 2)

arrows(x0 = 0, x1 = Hull.X.Cor, 
       y0 = 0, y1 = Hull.Y.Cor, 
       col = "deeppink", 
       length = 0.08, 
       lwd = 1.5,
       angle = 30)

text(x = Hull.X.Cor, y = Hull.Y.Cor, 
     labels = row.names(Hull.pca[["var"]][["cor"]]), 
     cex = 0.8,
     font = 1,
     col = "gray50",
     pos = c(1, 4, 4, 3, 2, 1, 2, 2, 3, 1)) #THMH, SMH, MTMH, PMH, HUMH, FMH, MAMH, HEMH, NMH, TOMH

dev.off()
